<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Doctrine\UuidGenerator;

/**
 * @ORM\Entity
 * @ORM\Table(name="external_adherent_data")
 * 
 * This table stores data to be visualised in a Metabase instance  
 */
class ExternalAdherentData
{
    /**
     * @var \Ramsey\Uuid\UuidInterface
     *
     * @ORM\Id
     * @ORM\Column(type="uuid", unique=true)
     * @ORM\GeneratedValue(strategy="CUSTOM")
     * @ORM\CustomIdGenerator(class=UuidGenerator::class)
     */
    private $id;

    /**
     * @ORM\OneToOne(targetEntity="Adherent", inversedBy="externalData")
     * @ORM\JoinColumn(name="adherent_id", referencedColumnName="id", nullable=false, unique=true)
     */
    private ?Adherent $adherent = null;

    /**
     * @ORM\ManyToOne(targetEntity="ExternalDataAgeGroup")
     * @ORM\JoinColumn(name="external_data_age_group_id", referencedColumnName="id", nullable=true)
     */
    private $externalDataAgeGroup;

    /** @ORM\Column(type="integer", nullable=true) */
    private $birthYear;

    /** @ORM\Column(type="integer", nullable=true) */
    private $ageIncomeRatioGroup;

    /** @ORM\Column(type="integer", nullable=true) */
    private $householdIncomeRatioGroup;

    /** @ORM\Column(type="string", length=255, nullable=true) */
    private $externalId;

    /** @ORM\Column(type="string", length=255, nullable=true) */
    private $cohort;

    /**
     * @ORM\ManyToOne(targetEntity="ExternalDataCCMemberStatus")
     * @ORM\JoinColumn(name="external_data_cc_member_status_id", referencedColumnName="id", nullable=true)
     */
    private $externalDataCCMemberStatus;

    public function setAdherent(?Adherent $adherent): self
    {
        $this->adherent = $adherent;

        return $this;
    }

    public function setExternalDataAgeGroup(?ExternalDataAgeGroup $externalDataAgeGroup): self
    {
        $this->externalDataAgeGroup = $externalDataAgeGroup;

        return $this;
    }

    public function setBirthYear(?int $birthYear): self
    {
        $this->birthYear = $birthYear;

        return $this;
    }

    public function setAgeIncomeRatioGroup(?int $ageIncomeRatioGroup): self
    {
        $this->ageIncomeRatioGroup = $ageIncomeRatioGroup;

        return $this;
    }

    public function setHouseholdIncomeRatioGroup(?int $householdIncomeRatioGroup): self
    {
        $this->householdIncomeRatioGroup = $householdIncomeRatioGroup;

        return $this;
    }

    public function setExternalId(?string $externalId): self
    {
        $this->externalId = $externalId;

        return $this;
    }

    public function setCohort(?string $cohort): self
    {
        $this->cohort = $cohort;

        return $this;
    }

    public function setExternalDataCCMemberStatus(?ExternalDataCCMemberStatus $externalDataCCMemberStatus): self
    {
        $this->externalDataCCMemberStatus = $externalDataCCMemberStatus;

        return $this;
    }

    public function getAdherent(): ?Adherent
    {
        return $this->adherent;
    }

    public function getExternalDataAgeGroup(): ?ExternalDataAgeGroup
    {
        return $this->externalDataAgeGroup;
    }

    public function getBirthYear(): ?int
    {
        return $this->birthYear;
    }

    public function getAgeIncomeRatioGroup(): ?int
    {
        return $this->ageIncomeRatioGroup;
    }

    public function getHouseholdIncomeRatioGroup(): ?int
    {
        return $this->householdIncomeRatioGroup;
    }

    public function getExternalId(): ?string
    {
        return $this->externalId;
    }

    public function getCohort(): ?string
    {
        return $this->cohort;
    }

    public function getExternalDataCCMemberStatus(): ?ExternalDataCCMemberStatus
    {
        return $this->externalDataCCMemberStatus;
    }
}
