<?php

namespace App\Admin;

use App\Entity\Flux;
use App\Entity\GlobalParameter;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Sonata\DoctrineORMAdminBundle\Filter\CallbackFilter;

/**
 * Administration des flux 'Achat de monnaie'.
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 *
 * @author Damien Moulard <dam.moulard@gmail.com>
 */
class AchatMonnaieAdmin extends FluxAdmin
{
    protected $baseRouteName = 'achat_monnaie';
    protected $baseRoutePattern = 'achat_monnaie';

    /**
     * {@inheritdoc}
     */
    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        //In mode ssa_friendly_flux_type_names, we display on this page all cotisation
        //initial operation (i.e. we display vente_emlc operations in addition to achat_monnaie)
        if($this->getConfigurationPool()->getContainer()->getParameter('tav_env')
            && $this->getConfigurationPool()->getContainer()->getParameter('ssa_friendly_flux_type_names')) {
            $query->andWhere($query->getRootAliases()[0] . '.parenttype = :parenttype' . ' OR ' . $query->getRootAliases()[0] . '.parenttype = :parenttype2')
                ->setParameter('parenttype', Flux::TYPE_ACHAT)
                ->setParameter('parenttype2', Flux::TYPE_VENTE_EMLC);
        } else {
            $query->andWhere($query->getRootAliases()[0] . '.parenttype = :parenttype')
                ->setParameter('parenttype', Flux::TYPE_ACHAT);
        }
        return $query;
    }

    // protected function configureRoutes(RouteCollection $collection)
    // {
    //     $collection->clearExcept(['create', 'list', 'export']);
    // }

    /**
     * {@inheritdoc}
     */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        if($this->getConfigurationPool()->getContainer()->getParameter('tav_env')
            && $this->getConfigurationPool()->getContainer()->getParameter('ssa_friendly_flux_type_names')) {
            $datagridMapper->add('type', null, [
                'advanced_filter' => false,
                'show_filter' => true,
                'field_type' => ChoiceType::class,
                'field_options' => [
                    'choices' => [
                        'Achat des adhérents' => 'achat_monnaie_adherent',
                        'Achat des prestataires' => 'achat_monnaie_prestataire',
                        'Vente aux adhérents' => 'vente_emlc_adherent',
                        'Vente aux prestataires' => 'vente_emlc_prestataire',
                    ],
                    'placeholder' => 'Indifférent',
                    'expanded' => false,
                    'multiple' => false,
                ],
            ]);
        } else {
            $datagridMapper->add('type', null, [
                'advanced_filter' => false,
                'show_filter' => true,
                'field_type' => ChoiceType::class,
                'field_options' => [
                    'choices' => [
                        'Adhérent' => 'achat_monnaie_adherent',
                        'Prestataire' => 'achat_monnaie_prestataire',
                    ],
                    'placeholder' => 'Indifférent',
                    'expanded' => true,
                    'multiple' => false,
                ],
            ]);
        }
    }

    /**
     * {@inheritdoc}
     */
    protected function configureListFields(ListMapper $listMapper)
    {
        parent::configureListFields($listMapper);
        $listMapper
            ->remove('type')
            ->remove('expediteur')
        ;
    }

    public function getTotalLabel()
    {
        $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager();

        return $this->translator->trans('Total des achats de e' . $em->getRepository(GlobalParameter::class)->val(GlobalParameter::MLC_SYMBOL));
    }

    public function getTotal()
    {
        $datagrid = $this->getDatagrid();
        $datagrid->buildPager();

        $query = clone $datagrid->getQuery();
        if($this->getConfigurationPool()->getContainer()->getParameter('tav_env')
            && $this->getConfigurationPool()->getContainer()->getParameter('ssa_friendly_flux_type_names')) {
            $query
                ->select('SUM( ' . $query->getRootAlias() . '.montant) as total')
                ->andWhere($query->getRootAlias() . '.parenttype = :parenttype' . ' OR ' . $query->getRootAliases()[0] . '.parenttype = :parenttype2')
                ->setParameter('parenttype', Flux::TYPE_ACHAT)
                ->setParameter('parenttype2', Flux::TYPE_VENTE_EMLC)
                ->setFirstResult(null)
                ->setMaxResults(null);
        } else {
            $query
                ->select('SUM( ' . $query->getRootAlias() . '.montant) as total')
                ->andWhere($query->getRootAlias() . '.parenttype = :parenttype')
                ->setParameter('parenttype', Flux::TYPE_ACHAT)
                ->setFirstResult(null)
                ->setMaxResults(null);
        }


        $result = $query->execute([], \Doctrine\ORM\Query::HYDRATE_SINGLE_SCALAR);

        return $result;
    }
}
