<?php

namespace App\Entity;

use App\Enum\CurrencyEnum;
use App\Utils\OperationFactory;
use Doctrine\ORM\Mapping as ORM;

/**
 *  * Dans les cas suivants :
 * - [Profil de Cotisation] La taux est supérieur à 1 
 * - [Allocation selon foyer] Le montant reçu calculé est supérieur au montant payé
 * - [Allocation selon foyer] Un administrateur effectue une opération de correction de solde qui conduit à un reversement.
 * 
 * L'adhérent•e reçoit plus d'emlc que ce qu'elle•il paye en €, 
 * un second flux est créé pour reverser le complément de la cotisation.
 *
 * @ORM\Entity
 */
class CotisationTavReversement extends CotisationTavApplication
{
    /**
     * @ORM\OneToOne(targetEntity="Siege")
     * @ORM\JoinColumn(name="siege_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Adherent")
     * @ORM\JoinColumn(name="adherent_id", referencedColumnName="id")
     */
    protected $destinataire;

    public function getAllOperations($em)
    {
        return [
            OperationFactory::getOperation($this, $this->getExpediteur(), CurrencyEnum::CURRENCY_EMLC, $this->getMontant()), // Increase Siege ecompte
            OperationFactory::getOperation($this, $this->getDestinataire(), CurrencyEnum::CURRENCY_EMLC, $this->getMontant()),
        ];
    }

    public function operate($em)
    {
        $this->getExpediteur()->addEcompteNantie($this->getMontant());
        $this->getDestinataire()->addEcompte($this->getMontant());

        return [$this->getExpediteur(), $this->getDestinataire()];
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return parent::TYPE_REVERSEMENT_COTISATION_ADHERENT;
    }

    public function getUsersToNotify()
    {
        return [];
    }
}
