<?php

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

/**
 * Administration des popups d'information.
 * Ces popup sont à destination des utilisateurs (adhérents uniquement pour l'instant),
 * et s'ouvrent automatiquement au lancement de l'application, 
 * tant que l'utilisateur n'a pas cliqué sur le bouton de confirmation
 * 
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 */
class InformationPopupAdmin extends AbstractAdmin
{
    protected function configureFormFields(FormMapper $form): void
    {
        $form
        ->add('title', TextType::class, [
            'label' => 'Titre',
            'required' => true,
        ])
        ->add('content', CKEditorType::class, [
            'label' => 'Contenu',
            'required' => true,
        ])
        ->add('validationButtonText', TextType::class, [
            'label' => 'Texte du bouton de validation',
            'required' => true,
            'attr' => [
                'placeholder' => 'Par exemple : "J\'ai compris", "J\'ai bien effectué l\'action"...',
            ],
            'help' => 'Le clic sur ce bouton entraînera la fermeture définitive de cette popup pour cet utilisateur, il est donc conseillé d\'y renseigner un texte explicite.'
        ])
        ->add('closingButtonText', TextType::class, [
            'label' => 'Texte du bouton de fermeture',
            'required' => true,
            'attr' => [
                'placeholder' => 'Par exemple : "Fermer pour l\'instant", "Je le ferai plus tard"...',
            ]
        ])
        ->add('enabled', null, [
            'label' => 'Activé ?',
            'help' => 'Une seule popup d\'information peut être active à la fois. Activer cette popup désactivera toutes les autres.'
        ]);
    }

    public function postPersist($informationPopup)
    {
        $this->disableOtherPopups($informationPopup);
    }

    public function preUpdate($informationPopup)
    {
        $this->disableOtherPopups($informationPopup);
    }

    /**
     * Only one popup should be enabled at a time.
     * If enableling a popup in the admin, disable the rest.
     */
    private function disableOtherPopups($informationPopup)
    {
        if (true == $informationPopup->getEnabled()) {
            $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager();
    
            $qb = $em->createQueryBuilder();
            
            $qb->update('App\Entity\InformationPopup', 'e')
                ->set('e.enabled', ':newValue')
                ->where('e.id != :id')
                ->setParameter('newValue', 0)
                ->setParameter('id', $informationPopup->getId());
        
            $query = $qb->getQuery();
            $query->execute();
        }
    }

    protected function configureDatagridFilters(DatagridMapper $datagrid): void
    {
        $datagrid
        ->add('title', null, [
            'label' => 'Titre'
        ]);
    }

    protected function configureListFields(ListMapper $list): void
    {
        $list
        ->addIdentifier('title', null, [
            'label' => 'Titre'
        ])
        ->add('enabled', null, [
            'label' => 'Activé ?',
        ]);
    }
}